package de.thedevstack.android.nextcloud.bookmark.share.async;

import android.content.Intent;
import android.preference.PreferenceManager;
import android.util.Log;
import android.widget.Toast;

import de.thedevstack.android.nextcloud.bookmark.share.Constants;
import de.thedevstack.android.nextcloud.bookmark.share.NextcloudBookmark;
import de.thedevstack.android.nextcloud.bookmark.share.NextcloudBookmarkService;
import de.thedevstack.android.nextcloud.bookmark.share.R;
import de.thedevstack.android.nextcloud.bookmark.share.activities.NextcloudPreferencesActivity;

/**
 * Represents an asynchronous login/registration task used to authenticate
 * the user.
 */
public class NextcloudCheckCredentialsTask extends NextcloudBookmarkRestAsyncTask<Intent, Boolean> {
    private NextcloudPreferencesActivity preferencesActivity;
    private NextcloudSettings ncSettings;
    private NextcloudBookmark bookmark;

    public NextcloudCheckCredentialsTask(NextcloudPreferencesActivity preferencesActivity, NextcloudBookmark bookmark, String serverUrl, String username, String password) {
        this(preferencesActivity, serverUrl, username, password);
        this.bookmark = bookmark;
    }

    public NextcloudCheckCredentialsTask(NextcloudPreferencesActivity preferencesActivity, String serverUrl, String username, String password) {
        super(serverUrl, username, password);
        this.preferencesActivity = preferencesActivity;
        this.ncSettings = new NextcloudSettings();
        this.ncSettings.serverUrl = serverUrl;
        this.ncSettings.username = username;
        this.ncSettings.password = password;
    }

    @Override
    protected Boolean doInBackground(Intent... params) {
        return this.client.checkCredentials();
    }

    @Override
    protected void onPostExecute(final Boolean success) {
        this.preferencesActivity.stopProgress();

        Log.d("NCCheckCredentials", "result is " + success);
        if (success) {
            Log.d("NCCheckCredentials", "applying preferences");
            PreferenceManager.getDefaultSharedPreferences(this.preferencesActivity.getApplicationContext())
                    .edit()
                    .putString(Constants.SERVER_URL_PREFERENCE_KEY, this.ncSettings.serverUrl)
                    .putString(Constants.USERNAME_PREFERENCE_KEY, this.ncSettings.username)
                    .putString(Constants.PASSWORD_PREFERENCE_KEY, this.ncSettings.password)
                    .commit();
            if (null != this.bookmark) {
                NextcloudBookmarkService.addBookmark(this.preferencesActivity, this.bookmark);
                this.preferencesActivity.finish();
            } else {
                Toast.makeText(this.preferencesActivity, R.string.toast_settings_update_success, Toast.LENGTH_LONG).show();
            }
        } else {
            this.preferencesActivity.showIncorrectPassword();
        }
    }

    @Override
    protected void onCancelled() {
        this.preferencesActivity.stopProgress();
    }

    private class NextcloudSettings {
        String serverUrl;
        String username;
        String password;
    }
}