package de.thedevstack.android.nextcloud.bookmark.share.async;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.preference.PreferenceManager;

import de.thedevstack.android.nextcloud.bookmark.share.Constants;
import de.thedevstack.android.nextcloud.bookmark.share.rest.NextcloudBookmarkRestClient;

/**
 */
public abstract class NextcloudBookmarkRestAsyncTask<Params, Result> extends AsyncTask<Params, Void, Result> {
    protected NextcloudBookmarkRestClient client;
    protected Context context;

    public NextcloudBookmarkRestAsyncTask(Context context){
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        String serverUrl = prefs.getString(Constants.SERVER_URL_PREFERENCE_KEY, null);
        String username = prefs.getString(Constants.USERNAME_PREFERENCE_KEY, null);
        String password = prefs.getString(Constants.PASSWORD_PREFERENCE_KEY, null);

        this.client = new NextcloudBookmarkRestClient(serverUrl, username, password);
        this.context = context;
    }

    public NextcloudBookmarkRestAsyncTask(String serverUrl, String username, String password) {
        this.client = new NextcloudBookmarkRestClient(serverUrl, username, password);
    }
}
