package de.thedevstack.android.nextcloud.bookmark.share.async;

import android.app.Activity;
import android.util.Log;
import android.widget.Toast;

import de.thedevstack.android.nextcloud.bookmark.share.R;

/**
 */
public class NextcloudAddBookmarkAsyncTask extends NextcloudBookmarkRestAsyncTask<String, Integer> {

    public NextcloudAddBookmarkAsyncTask(Activity context) {
        super(context.getApplicationContext());
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
    }

    @Override
    protected Integer doInBackground(String... params) {
        String bookmarkUrl = params[0];
        //String bookmarkTitle = params[1];

        return this.client.addBookmark(bookmarkUrl);
    }

    @Override
    protected void onPostExecute(Integer resultCode) {
        if (200 == resultCode) {
            Log.i("NCAddBookmarkAsync", "Bookmark successfully set");
            Toast.makeText(context, R.string.toast_bookmark_add_success, Toast.LENGTH_LONG).show();
        } else {
            Log.e("NCAddBookmarkAsync", "Failed to set Bookmark");
            Toast.makeText(context, R.string.toast_bookmark_add_failed, Toast.LENGTH_LONG).show();
        }
    }
}
