package de.thedevstack.android.nextcloud.bookmark.share.activities;

import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;

import de.thedevstack.android.nextcloud.bookmark.share.Constants;
import de.thedevstack.android.nextcloud.bookmark.share.NextcloudBookmarkService;

/**
 */
public class NextcloudBookmarkShareActivity extends AppCompatActivity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Intent intent = getIntent();
        String action = intent.getAction();
        String type = intent.getType();

        if (Intent.ACTION_SEND.equals(action) && type != null) {  // Opened via share menu
            if ("text/plain".equals(type)) {
                SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(NextcloudBookmarkShareActivity.this.getApplicationContext());

                if (!existsAndIsNotEmpty(prefs, Constants.SERVER_URL_PREFERENCE_KEY)
                        || !existsAndIsNotEmpty(prefs, Constants.USERNAME_PREFERENCE_KEY)
                        || !existsAndIsNotEmpty(prefs, Constants.PASSWORD_PREFERENCE_KEY)) {
                    Intent settingsActivityIntent = new Intent(this, NextcloudPreferencesActivity.class);

                    String bookmarkUrl = intent.getStringExtra(Intent.EXTRA_TEXT);
                    String bookmarkTitle = intent.getStringExtra(Intent.EXTRA_TITLE);

                    settingsActivityIntent.putExtra(Intent.EXTRA_TEXT, bookmarkUrl);
                    settingsActivityIntent.putExtra(Intent.EXTRA_TITLE, bookmarkTitle);

                    startActivity(settingsActivityIntent);
                } else {
                    NextcloudBookmarkService.addBookmark(this, intent);
                }
            }
        }
        this.finish();
    }

    private boolean existsAndIsNotEmpty(SharedPreferences prefs, String prefKey) {
        return !TextUtils.isEmpty(prefs.getString(prefKey, ""));
    }
}
