package de.thedevstack.android.nextcloud.bookmark.share;

import android.app.Activity;
import android.content.Intent;

import de.thedevstack.android.nextcloud.bookmark.share.async.NextcloudAddBookmarkAsyncTask;

/**
 */
public class NextcloudBookmarkService {
    public static void addBookmark(Activity context, Intent intent) {
        String bookmarkUrl = intent.getStringExtra(Intent.EXTRA_TEXT);
        String bookmarkTitle = intent.getStringExtra(Intent.EXTRA_TITLE);

        addBookmark(context, bookmarkUrl, bookmarkTitle);
    }

    public static void addBookmark(Activity context, String bookmarkUrl, String bookmarkTitle) {
        new NextcloudAddBookmarkAsyncTask(context).execute(bookmarkUrl, bookmarkTitle);
    }

    public static void addBookmark(Activity context, NextcloudBookmark bookmark) {
        new NextcloudAddBookmarkAsyncTask(context).execute(bookmark.getBookmarkUrl(), bookmark.getBookmarkTitle());
    }
}
